//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

Item {
    id : scrollBar

    property real size : .1
    property real position : 0

    readonly property alias pressed : mouseArea.pressed

    signal scrollRequested(real position)

    implicitHeight : 12
    implicitWidth : 100

    MouseArea {
        id : mouseArea

        acceptedButtons : Qt.LeftButton
        preventStealing : true
        hoverEnabled : true

        anchors.fill : scrollBar

        onPressed : {
            const handlePos = handle.mapFromItem(scrollBar, mouse.x, mouse.y);
            if (!handle.contains(handlePos)) {
                const scrollPos = mouse.x / Math.max(1.0, width);
                scrollBar.scrollRequested(
                            Math.max(0, Math.min(1, scrollPos)));
                handle.lowerBound = handle.width * scrollPos;
                handle.upperBound =
                        scrollBar.width - handle.width * (1.0 - scrollPos);
            } else {
                const clickPos = handlePos.x / handle.width;
                handle.lowerBound = handle.width * clickPos;
                handle.upperBound =
                        scrollBar.width - handle.width * (1.0 - clickPos);
            }
        }
        onPositionChanged : {
            if (!pressed)
                return;

            const scrollPos = (mouse.x - handle.lowerBound) /
                    (handle.upperBound - handle.lowerBound);
            scrollBar.scrollRequested(Math.max(0, Math.min(1, scrollPos)));
        }
    }

    Rectangle {
        id : handle

        property int upperBound : 0
        property int lowerBound : 0

        anchors {
            top : scrollBar.top
            bottom : scrollBar.bottom
        }

        color : UiColors.getColor(UiColors.HeaderGrey4)
        width : Math.max(20, Math.min(1.0, scrollBar.size) * scrollBar.width)

        x : (scrollBar.width - handle.width) * scrollBar.position

        border {
            width : 1
            color : UiColors.getColor(UiColors.DisabledLightGrey13)
        }
    }
}
